;								EJEMPLO 34
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El mdulo conversor ADC. 
;
;Los dispositivos PIC16F87X disponen de un convertidor A/D de 10 bits de resolucin y 5 u 8 
;canales de entrada analgica. La tensin de referencia determina la resolucin por bit:
;(Res. = Vref/1024). Con 5 Vref=4.8 mV/Bit; con 2.5 Vref=2.4 mV/Bit
;
;El ejemplo propone realizar la conversin de la tensin presente en el canal RA0/AN0. Esta
;se puede variar con el potencimetro P1 del laboratorio. El resultado de la conversin se 
;visualiza, en binario, sobre la pantalla LCD.

		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Lcd_var		equ	0x20		;Variables de las rutinas LCD
Temporal_1	equ	0x22		;Variable temporal

			org	0x00		;Vector de RESET	
			goto	Inicio
			org	0x05

		include	"LCD_CXX.INC"	;Incluye rutinas de manejo del LCD

;Visualiza: Esta rutina coge los 10 bits resultantes de la conversin, presentes en ADRESH
;y ADRESL, los convierte a caracteres ACII (0 o 1) y los visualiza sobre el LCD.

Visualiza:	movlw	0x80
			call	LCD_REG		;Sita el cursor del LCD
			movlw	.9
			movwf	Temporal_1	;N de caracteres a visualizar
Visual_loop	bsf		STATUS,RP0
			rlf		ADRESL,F
			bcf		STATUS,RP0
			rlf		ADRESH,F	;Rotacin del siguiente bit
			btfsc	STATUS,C	;Testea el bit a visualizar
			goto	Bit_1		;Est a 1
			movlw	'0'
			goto	Visu_1
Bit_1		movlw	'1'
Visu_1		call	LCD_DATO	;Visualiza el "0" o el "1" sobre el LCD
			decfsz	Temporal_1,F	;Siguiente caracter
			goto	Visual_loop
			return

;Programa principal

Inicio	   	clrf	PORTA
			clrf	PORTB
			bsf		STATUS,RP0	;Selecciona banco 1
			movlw	b'00000110'
			movwf	ADCON1		;Puerta A E/S digitales
			clrf	TRISB		;Puerta B se configura como salida
			clrf	TRISA		;RA5-RA0 salidas
			bcf		STATUS,RP0	;Selecciona banco 0
			call	UP_LCD		;Configura E/S para el LCD
			call	LCD_INI		;Secuencia de inicio del LCD
			movlw	b'00001100'
			call	LCD_REG		;LCD On, cursor y blink Off

;Se activa el ADC y se selecciona el canal RA0/AN0. Frecuencia de trabajo Fosc/32
	
			movlw	b'10000001'
			movwf	ADCON0		;ADC en On, seleciona canal AN3
Loop		bsf		STATUS,RP0	;Selecciona pgina 1
			movlw	b'00111111'
			movwf	TRISA		;Puerta A entradas
			clrf	ADCON1		;Puerta A entradas analgicas
			bcf		STATUS,RP0	;Selecciona pgina 0
			bcf		PIR1,ADIF	;Restaura el flag del conversor AD
			nop
			bsf		ADCON0,GO	;Inicia la conversin

ADC_Wait	btfss	PIR1,ADIF	;Fin de conversin ??
			goto	ADC_Wait	;Todava no
		
;Las lneas de la Puerta A se reconfiguran como salidas digitales para la visualizacin

			bsf		STATUS,RP0	;Selecciona banco 1
			movlw	b'00000110'
			movwf	ADCON1		;Puerta A digital
			bcf		STATUS,RP0	;Selecciona banco 0
			call	UP_LCD		;Reconfigura E/S para el LCD
			call	Visualiza	;Visualiza el resultado de la conversin
			goto	Loop

			end					;Fin del programa fuente
